function [c,dc,u] = Fem2D_stiffness(matprop,nodedata,elemdata,rho,eta,F,dispbc)
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here

Nnode=size(nodedata,1);
Ksing = Kglobal(matprop,nodedata,elemdata,rho,eta);
Ksing = sparse(Ksing);
K=Ksing;
%
% Displacement boundary conditions
Nfix = size(dispbc,1);
    dispID(1:Nfix) = (dispbc(:,1)-1).*2+dispbc(:,2);
    dispVal(1:Nfix) = dispbc(:,3);
[dispID,sortIndex] = sort(dispID);
dispVal = dispVal(sortIndex);
% Imposing the boundary conditions
% ------------------------------------------
% dispID array contains the dof which are assigned specified values.
[~,sn] = size(dispID);
Ndbc = sn;
for nd=1:Ndbc,
    for nr=1:2*Nnode-nd+1,
        F(nr) = F(nr) - K(nr,dispID(nd)-nd+1) * dispVal(nd);
    end
    K = matcut(K,dispID(nd)-nd+1);
    F = veccut(F,dispID(nd)-nd+1);
end
F=sparse(F);
% To solve for unknown displacements.

U = K\F;
%
% Compile results and the specified displacements into one vector
%
u = zeros(2*Nnode,1);
%
for iu=1:Ndbc,
    u(dispID(iu)) = 12345.12345;
end
%
iuc = 0;
for iu=1:2*Nnode,
    if u(iu) == 12345.12345
        iuc = iuc+1;
         u(iu) = dispVal(iuc);
    else
        u(iu) = U(iu-iuc);
    end
end
c=u'*Ksing*u;
dc=get_dc(matprop,elemdata,rho,eta,u);

end